#!/bin/csh

xyz2pipe -in fid/test%03d.fid -x  \
| nmrPipe  -fn SOL                                               \
| nmrPipe  -fn SP -off .35 -end .98 -pow 2 -c 0.5                \
| nmrPipe  -fn ZF -auto                                          \
| nmrPipe  -fn FT -auto -verb                                    \
| nmrPipe  -fn PS -p0 -6.0   -p1 0.0  -di                        \
| nmrPipe  -fn EXT -x1  12ppm -xn 5.0ppm -sw                   \
| nmrPipe  -fn POLY -auto                                        \
| pipe2xyz  -out t1_fids/test%03d.ft1 -x -ov

xyz2pipe -in t1_fids/test%03d.ft1 -z  \
| nmrPipe  -fn SP -off .35 -end 1.0 -pow 1 -c 0.5                \
| nmrPipe  -fn ZF -auto                                          \
| nmrPipe  -fn FT -alt -verb                                    \
| nmrPipe  -fn PS -p0 00.0 -p1 0.0    -di                        \
#| nmrPipe  -fn EXT -x1  179.0ppm -xn 173.0ppm -sw                   \
| pipe2xyz -out t1t3_fids/test%03d.ft2 -z -ov

 
echo Processing Z dimension with Linear Prediction

xyz2pipe -in t1t3_fids/test%03d.ft2 -y  \
| nmrPipe  -fn LP -fb                                            \
| nmrPipe  -fn SP -off 0.41 -end 1.0 -pow 1 -c 0.5                \
| nmrPipe  -fn ZF -auto                                          \
| nmrPipe  -fn FT -auto -verb                                    \
| nmrPipe  -fn PS -p0 0.0 -p1 0.0  -di                         \
| pipe2xyz -out lp/trhnco%03d.DAT -z  -ov

#rm -r t1_fids t1t3_fids

xyz2pipe -in lp/trhnco%03d.DAT -x  \
| pipe2xyz -out trhnco.nv -nv 

#rm -r lp
 
echo DONE.


